<?php
namespace wpquads;

use wpquads;

/**
 * Class TextArea
 * @package WPStaging\Forms\Elements
 */
class TextArea extends Elements
{

    /**
     * @return string
     */
    protected function prepareOutput()
    {
        return "<textarea id='{$this->getId()}' name='{$this->getName()}' {$this->prepareAttributes()}>{$this->default}</textarea>";
    }

    /**
     * @return string
     */
    public function render()
    {
        return ( $this->renderFile ) ? quads_local_file_get_contents( $this->renderFile ) : $this->prepareOutput();
    }
}